
version 15 //Versionsnummer
use ESS8Happy.dta, clear //Datensatz einlesen
set more off


***Streudiagramme mit Gerade, Jitter und Titel untereinander
graph twoway ///
   || lfit happy ppltrst                          ///
   || scatter happy ppltrst, jitter(5)                     ///
   , nodraw xtitle("Trust in other people" " " "0=You can't be too careful; 10=Most people can be trusted") ///
     ytitle("How happy are you?" " " "0=Extremely unhappy" "10=Extremely happy") legend(off) ///
     name(g1, replace) 

graph twoway ///
  || lfit happy ppltrst02                           ///
  || scatter happy ppltrst02, jitter(5)                       ///
  , nodraw xtitle("Trust in other people" " " "0=Most people can be trusted; 10=You can't be too careful") ///
    ytitle("How happy are you?" " " "0=Extremely unhappy" "10=Extremely happy") legend(off)  ///
    name(g2, replace) 

graph combine g1 g2, xsize(8)


use ESS8.dta, clear //neuer Datensatz
 
/*Streudiagramm mit horizontaler Linie der Mittelwerte von Y 
und vertikaler Linie der Mittelwerte von X*/

sum happy ppltrst //Mittelwerte ausgeben

sum happy, meanonly
local happym = r(mean)
sum ppltrst, meanonly
local ppltrstm = r(mean)
scatter happy ppltrst, xline(`ppltrstm') yline(`happym')

***Weitere Inhalte wurden im Graph-Editor modifiziert***

***Streudiagramm mit Regressionsgerade durch Nullpunkt (Abbildung: Varianzzerlegung im Regressionsmodell)

use stflife.dta //neuer Datensatz

sc stflife pplfair || lfit stflife pplfair, range(0 10) xlabel(0(1)10, grid)plotregion(margin(zero))


***Grafik nicht-linearer Zusammenhänge

local gr1 yaxis(1) yscale(off axis(1))
local gr2 yaxis(2) yscale(off axis(2))
local gr3 yaxis(3) yscale(off axis(3))

graph twoway ///
|| function y = ln(x), `gr1' ///
|| function y = (-1) * x + x^2, `gr2' ///
|| function y = x^3, `gr3' ///
|| , legend(order(1 "Logarithmisch" 2 "U-Förmig"  3 "Hyperbolisch" ) rows(1))


*** Marginsplots für Interaktionen (modifiziert)

use allbus2012_inter.dta, clear //neuer Datensatz

sum v220 if !missing(index, v100r, v220)
gen c_v220=v220-r(mean)


regress index c.c_v220##i.v100r

margins v100r, at(c_v220=(0(2)12))

marginsplot, noci plotregion(margin(zero)) plot1opts(msymbol(p)) plot2opts(msymbol(p)) plot3opts(msymbol(p))xmtick(1(1)12) ymtick(2.5(0.1)4)  ytitle("")
