***Übungsaufgaben


version 15 //Versionsnummer

* Aufgabe 1

use fear.dta clear
set more off

*Wilcoxon Rangsummen Test berechnen

signrank fear1=fear2
 
/*Wilcoxon signed-rank test

        sign |      obs   sum ranks    expected
-------------+---------------------------------
    positive |       20         738         497
    negative |        8         256         497
        zero |       21         231         231
-------------+---------------------------------
         all |       49        1225        1225

unadjusted variance    10106.25
adjustment for ties      -56.88
adjustment for zeros    -827.75
                     ----------
adjusted variance       9221.63

Ho: fear1 = fear2
             z =   2.510
    Prob > |z| =   0.0121

*/

* Wir berechnen die Differenz fear1 - fear2 (könnten wir auch umkehren, dann ändert sich das Vorzeichen der Teststatistik)
* Das positive Vorzeichen der Teststatistik verweist darauf, dass sich die Angst nach dem Kurs verringert hat
* Das Vorzeichen entspricht dem lt. Forschungshypothese: p-Wert durch 2 teilen: 0.0121/2=0.00605
* Wir können die Nullhypothese mit einer Irrtumswahrscheinlichkeit von 5 % und 1 % verwerfen, aber nicht mit 1  (0.001)%

* Median und arithmetisches Mittel bestimmen


tabstat fear1 fear2, statistics(p50 mean iqr)

/*
   stats |     fear1     fear2
---------+--------------------
     p50 |         6         5
    mean |      5.42  4.653061
     iqr |         2         3
------------------------------*/

* Der Median der Angst lag vor dem Kurs bei 6, danach liegt er bei 5, das arithmetische Mittel war zuvor 5.42 (eher mittelgroße Angst) und ist nun 
* etwas geringer mit einem Wert von 4.65. Die Streuung (Interquartilsabstand) ist nach dem Kurs aber größer (3 statt 2), d.h. die Einschätzung
* der Angst ist nun unter den Befragten heterogener.


* Aufgabe 2

use ESS8DE.dta clear 

ci means netustm
* Mit einer 95 % Sicherheitswahrscheinlichkeit liegt der Mittelwert 187.1606 im Intervall [179.6844 ;194.6369]
* Das Intervall mit den Grenzen 179.68 bis 194.64 Minuten enthält den (unbekannten) Mittelwert mit einer Sicherheitswahrscheinlichkeit von 95 %. 
* Andere Interpretation: Das Konfidenzintervall stellt die Spannenweite [179.6844 ;194.6369] von plausiblen Werten für den unbekannten Mittelwert dar

ci means netustm, level(99)
* Interpretation wie oben, aber: Das Intervall ist breiter, 
* da eine höhere Sicherheitswahrscheinlichkeit als beim 95 % Konfidenzintervall gewählt wurde


* Aufgabe 3

use ESS8DE.dta clear

*Wilcoxon Vorzeichen Rang Test

* Die abhängige Variable ist ordinal und die unabhängige dichotom -> Wilcoxon-Rangsummen Test anwenden (oder den exakten Test ranksumex)
* Codierung der Variable für Interpretation bestimmen

label list health gndr

/*         1 Very good
           2 Good
           3 Fair
           4 Bad
           5 Very bad 
		   
		   1 Male
           2 Female
          .d No answer
*/
		 
ranksum health, by(gndr)

/*Two-sample Wilcoxon rank-sum (Mann-Whitney) test

        gndr |      obs    rank sum    expected
-------------+---------------------------------
        Male |     1507   2099389.5     2147475
      Female |     1342   1960435.5     1912350
-------------+---------------------------------
    combined |     2849     4059825     4059825

unadjusted variance   4.803e+08
adjustment for ties   -55800835
                     ----------
adjusted variance     4.245e+08

Ho: health(gndr==Male) = health(gndr==Female)
             z =  -2.334
    Prob > |z| =   0.0196                      */

* Ho: health(gndr==Male) = health(gndr==Female)steht für die Nullhypothese: identische Verteilungen
* Unsere Forschungshypothese lautet: Frauen (Gruppe 2) schätzen ihre Gesundheit schlechter ein als Männer; diese Hypothese ist gerichtet
* Der Wert der Teststatistik weist darauf hin, dass Männer ihre Gesundheit besser einschätzen als Frauen (Differenz Gruppe 1-2 ist negativ):
* Das Vorzeichen stimmt mit unser Forschungshypothese überein, nun müssen wir den p-Wert durch 2 teilen, 
* da dieser für den zweiseitigen Test steht: 0.0196/2= 0.0098
* Wir können unsere Nullhypothese mit einer Irrtumswahrscheinlichkeit von 5 % und 1 % verwerfen, aber nicht mit 1 %

* Median, arithmetisches Mittel und Interquartilsabstand bestimmen

tabstat health, statistic (p50 mean iqr) by(gndr)
	
/*Summary for variables: health
     by categories of: gndr (Gender)


     gndr |       p50      mean       iqr
----------+------------------------------
     Male |         2  2.313869         1
   Female |         2  2.390462         1
----------+------------------------------
    Total |         2  2.349947         1
----------------------------------------- */

* Männer und Frauen weisen einen Median von 2 auf, Frauen schätzen ihre Gesundheit mit einem Mittelwert 2,39 etwas schlechter ein als Männer;
* die Streuung ist bei beiden vergleichbar (Interquartilsabstand 1)

* Aufgabe 4

* Ein Balkendiagramm mit Fehlerbalken (Konfidenzintervall) kann als grafische Lösung erzeugt werden
* Balendiagramm mit 95 % Konfidenzintervall oder 99 % 99.9% etc.

cibar nwspol, over1(gndr)
cibar nwspol, over1(gndr) level(99)
cibar nwspol, over1(gndr) level(99.9)

* Die ersten beiden Konfidenzintervalle überlappen nicht -> Mit einer Sicherheitswahrscheinlichkeit von 95 % und 99 % (Irrtumswahrscheinlichkeit 5 % und 1 %)
* können wir die Forschungshypothese bestätigen, dass es Unterschiede hinsichtlich des Interesses an Nachrichten zum politischen Geschehen gibt
* Bei einer Sicherheitswahrscheinlichkeit von 99.9 % (Irrtumswahrscheinlichkeit 0.1 %) überlappen die Fehlerbalken,
* aber die Balken schließen den jeweiligen Stichprobenmittelwert der anderen Gruppe nicht ein  ->
* Wir können anhand der Fehlerbalken keinen eindeutigen Schluss ziehen

* Es kann auch der t-Test für unabhängige Stichproben berechnet werden

ttest nwspol, by(gndr)
*bzw. bei Varianzungleichheit
ttest nwspol, by(gndr) unequal

* Aufgabe 5
esizei 1508 73.47 88.10 1343 60.12 78.98

/*

Effect size based on mean comparison

                               Obs per group:
                                     Group 1 =      1,508
                                     Group 2 =      1,343
---------------------------------------------------------
        Effect Size |   Estimate     [95% Conf. Interval]
--------------------+------------------------------------
          Cohen's d |   .1590656     .0853984    .2327049
         Hedges's g |   .1590237     .0853759    .2326436
---------------------------------------------------------
*/

* Die Effektstärke nach Cohen (0.16) ist gering 


* Aufgabe 6

use digilmeth.dta, clear

* t-Test für abhängige Stichproben ist erforderlich, da metrische Variablen und abhängige Stichproben
* Gerichtete Forschungshypothese: Mit neuer Lehrmethode sollen im Mathetest mehr Punkte erzielt werden:
* Differenz der Punkte im Mathetest 1- Mathetest 2 sollen kleiner als 0 ausfallen

ttest matht1= matht2

/*
Paired t test
------------------------------------------------------------------------------
Variable |     Obs        Mean    Std. Err.   Std. Dev.   [95% Conf. Interval]
---------+--------------------------------------------------------------------
  matht1 |      60    1.633333    .1175712    .9107022    1.398074    1.868593
  matht2 |      60    2.041667    .1253761     .971159     1.79079    2.292544
---------+--------------------------------------------------------------------
    diff |      60   -.4083333    .1299129    1.006301   -.6682884   -.1483783
------------------------------------------------------------------------------
     mean(diff) = mean(matht1 - matht2)                           t =  -3.1431
 Ho: mean(diff) = 0                              degrees of freedom =       59

 Ha: mean(diff) < 0           Ha: mean(diff) != 0           Ha: mean(diff) > 0
 Pr(T < t) = 0.0013         Pr(|T| > |t|) = 0.0026          Pr(T > t) = 0.9987*/
 
/* Folgende Elemente müssen wir betrachten: Ha: mean(diff) < 0/  Pr(T < t) = 0.0013, Unsere Forschungshypothese wird mit einer Irrtumswahrscheinlichkeit
  von 5 % und 1 % (vorläufig) angenommen, nicht aber mit 0,1 %.
  Wir könnten auch die Differenz Mathetest 2-Mathetest 1 rechnen: Dann wäre es ein rechtsseitiger Test: Differenz Mathetest 2-Mathetest 1 größer */


ttest matht2= matht1

/*

Paired t test
------------------------------------------------------------------------------
Variable |     Obs        Mean    Std. Err.   Std. Dev.   [95% Conf. Interval]
---------+--------------------------------------------------------------------
  matht2 |      60    2.041667    .1253761     .971159     1.79079    2.292544
  matht1 |      60    1.633333    .1175712    .9107022    1.398074    1.868593
---------+--------------------------------------------------------------------
    diff |      60    .4083333    .1299129    1.006301    .1483783    .6682884
------------------------------------------------------------------------------
     mean(diff) = mean(matht2 - matht1)                           t =   3.1431
 Ho: mean(diff) = 0                              degrees of freedom =       59

 Ha: mean(diff) < 0           Ha: mean(diff) != 0           Ha: mean(diff) > 0
 Pr(T < t) = 0.9987         Pr(|T| > |t|) = 0.0026          Pr(T > t) = 0.0013*/

* Folgendes Element müssen wir nun betrachten: Ha: mean(diff) > 0/ Pr(T > t) = 0.0013; Interpretation siehe oben.
 

* Aufgabe 7

* Ein-Stichproben Test berechnen
* Unterschiedshypothese, gerichtet, linksseitiger Test:
* Die Forschungshypothese lautet: der Mittelwert ist kleiner als 70 Minuten

ttest nwspol==73

/*
One-sample t test
------------------------------------------------------------------------------
Variable |     Obs        Mean    Std. Err.   Std. Dev.   [95% Conf. Interval]
---------+--------------------------------------------------------------------
  nwspol |   2,851    67.17888    1.576463    84.17486    64.08776    70.27001
------------------------------------------------------------------------------
    mean = mean(nwspol)                                           t =  -3.6925
Ho: mean = 73                                    degrees of freedom =     2850

    Ha: mean < 73               Ha: mean != 73                 Ha: mean > 73
 Pr(T < t) = 0.0001         Pr(|T| > |t|) = 0.0002          Pr(T > t) = 0.9999
*/

* Diese Elemente müssen wir interpretieren. Ha: mean < 73/  Pr(T < t) = 0.0001 ; p < 0.001 -> Wir können die Nullhypthese (vorläufig) 
* mit einer Irrtumswahrscheinlichkeit von 5 %, 1 % und 0.1 % ablehnen.
* Anhand der Daten akzeptieren wir (vorläufig) unsere Forschungshypothese mit einer Irrtumswahrscheinlichkeit von 0.1%.
* Im Durchschnitt verbringen die Bürger weniger als 73 Stunden mit Nachrichten schauen.

* Interpretation des Konfidenzintervalls wie in Aufgabe 2. Zusätzlich als Signifikanztest möglich:
* Der hypothetische Wert (73) liegt nicht im 95 % Konfidenzintervall; eine ungerichtete Nullhypothese müssten wir ablehnen; aber wir müssen 
* das 2*alpha-Konfidenzintervall für die Überprüfung der gerichteten Hypothese mit einer Irrtumswahrscheinlichkeit von 5 % berechnen:

 ci means nwspol, level(90)

/*    Variable |        Obs        Mean    Std. Err.       [90% Conf. Interval]
-------------+---------------------------------------------------------------
      nwspol |      2,851    67.17888    1.576463        64.58499    69.77278*/

* Der hypothetische Wert (73) liegt nicht im Konfidenzintervall und der Stichprobenmittelwert ist kleiner als der hypothetische Wert ->
* Die Nullhypothese wird mit einer Irrtumswahscheinlichkeit von 5 % verworfen
* Falls wir Alpha auf 0.01 setzten berechnen wir 2*0.01=0.02-> 100-0.02=98 


 ci means nwspol, level(98)

/*    Variable |        Obs        Mean    Std. Err.    [99.98% Conf. Interval]
-------------+---------------------------------------------------------------
      nwspol |      2,851    67.17888    1.576463        61.30836    73.04941*/
	  
* Berechnung für Irrtumswahscheinlichkeit von 0.1 % :
	  
ci means nwspol, level(99.8)

/*

    Variable |        Obs        Mean    Std. Err.     [99.8% Conf. Interval]
-------------+---------------------------------------------------------------
      nwspol |      2,851    67.17888    1.576463        62.30274    72.05503*/

* Die Ergebnisse sind wie oben: der Wert 73 liegt in keinem der Konfidenzintervalle;


* Aufgabe 8

* t-Test für unabhängige Stichproben verwenden
* Zuvor testen, ob Varianzen gleich sind

robvar wkhtot if agea<66, by(gndr)

/*

            |   Summary of Total hours normally
            |     worked per week in main job
            |          overtime included
     Gender |        Mean   Std. Dev.       Freq.
------------+------------------------------------
       Male |   41.630878    13.15789       1,127
     Female |   33.770475   13.906604         989
------------+------------------------------------
      Total |   37.956994   14.067771       2,116

W0  =  37.014609   df(1, 2114)     Pr > F = 0.00000000

W50 =  23.090651   df(1, 2114)     Pr > F = 0.00000165

W10 =  28.288108   df(1, 2114)     Pr > F = 0.00000012

*/

* Die H0 lautet: die Varianzen sind gleich. Diese Elemente müssen wir interpretieren: W0 = 37.014609 df(1, 2114) Pr > F = 0.00000000
* Die H0 wird mit einer Irrtumswahrscheinlichkeit von 0.1 % abgelehnt -> die Varianzen sind ungleich
* t-Test für unabhängige Stichproben und ungleiche Varianzen verwenden


ttest wkhtot if agea<66, by(gndr) unequal

/*
Two-sample t test with unequal variances
------------------------------------------------------------------------------
   Group |     Obs        Mean    Std. Err.   Std. Dev.   [95% Conf. Interval]
---------+--------------------------------------------------------------------
    Male |   1,127    41.63088    .3919442    13.15789    40.86186     42.3999
  Female |     989    33.77048    .4422043     13.9066    32.90271    34.63824
---------+--------------------------------------------------------------------
combined |   2,116    37.95699    .3058211    14.06777    37.35725    38.55674
---------+--------------------------------------------------------------------
    diff |            7.860403    .5909018                6.701571    9.019236
------------------------------------------------------------------------------
    diff = mean(Male) - mean(Female)                              t =  13.3024
Ho: diff = 0                     Satterthwaite's degrees of freedom =   2043.5

    Ha: diff < 0                 Ha: diff != 0                 Ha: diff > 0
 Pr(T < t) = 1.0000         Pr(|T| > |t|) = 0.0000          Pr(T > t) = 0.0000

*/


* Es wird die Differenz Männer - Frauen berechnet (diff = mean(Male) - mean(Female)), da Männer mit 1 und Frauen mit 2 kodiert sind.
* Laut unserer Forschungshypothese sollte die Differenz der Arbeitsstunden von Männern - Frauen somit größer als 0 sein -> der Ablehnungsbereich
* der Nullhypothese ist somit rechts
* Wir müssen diese Elemente betrachten: Ha: diff > 0/Pr(T > t) = 0.0000 -> Mit einer Irrtumswahrscheinlichkeit von 0.1 % können wir
* unsere Forschungshypothese (vorläufig) annehmen. Männer arbeiten durchschnittlich mehr Stunden als Frauen, im Schnitt 41.63 Stunden, Frauen nur 33,77 Stunden
* Es ist aber zu bachten, dass wir weitere Variablen (Kindererziehung, Art der Beschäftigung ezc.) nicht berücksichtigen
* Interpretation der Konfidenzintervalle:
* Mit einer 95 % Sicherheitswahrscheinlichkeit liegt der Mittelwert der Männer (41.63 Stunden) im Intervall von 40.86186 bis 42.3999] Stunden
* Mit einer 95 % Sicherheitswahrscheinlichkeit liegt der Mittelwert der Frauen 33.77 Stunden) im Intervall [32.90271;34.63824] 
* Die 95 % Konfidenzintervalle überschneiden sich nicht und das Konfidenzintervall der Mittelwertdifferenzen enthält den Wert 0 nicht -> 
* Unterschiede signifikant mit 5 % Irrtumswahrscheinlichkeit oder weniger

* Effektgröße berechnen

esize twosample wkhtot if agea<66, by(gndr) cohensd

/*Effect size based on mean comparison

                               Obs per group:
                                        Male =      1,205
                                      Female =      1,072
---------------------------------------------------------
        Effect Size |   Estimate     [95% Conf. Interval]
--------------------+------------------------------------
          Cohen's d |   .5816931     .4944481    .6688058
---------------------------------------------------------*/

* Die Effektgröße (0.58) ist als Mittel zu bezeichnen
	 
