***Übungsaufgaben 


version 15 //Versionsnummer
use survey.dta clear //Datensatz einlesen
set more off

* Aufgabe 1a

* Abhängige Variable 0/1 kodieren: verschiedene Varianten möglich

codebook grass
ta grass, gen(marih)

* Alternativen

* recode grass (1=1)(2=0),gen(marih)

* gen marih=1 if grass==1
* replace marih=0 if grass==2

* Geschlecht 0/1 kodieren (nur für Regression ohne Faktorvariablen)

recode sex(1=0)(2=1), gen(dsex)

* Die abhängige Variable marih1 weist den Wert 1 für Personen auf, die für die Legalisierung sind
* Beim Geschlecht steht der Wert 1 für Frauen, Männer sind die Referenz

* Zur Berechnung verwenden wir für die kategoriale Variablen sex die Faktor Variablen Notation

logit marih1 i.sex educ age
logit, or
listcoef, help
listcoef, reverse help

* Oder mit Prozentwerten: listcoef, reverse percent
/*Logistic regression                           Number of obs     =      1,832
                                                LR chi2(3)        =      97.44
                                                Prob > chi2       =     0.0000
Log likelihood = -1175.3102                     Pseudo R2         =     0.0398

------------------------------------------------------------------------------
      marih1 |      Coef.   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
         sex |
     female  |  -.3747613   .0995196    -3.77   0.000    -.5698162   -.1797065
        educ |   .0869197    .016487     5.27   0.000     .0546057    .1192337
         age |  -.0204921   .0028396    -7.22   0.000    -.0260576   -.0149265
       _cons |    .477791   .2710422     1.76   0.078     -.053442    1.009024
------------------------------------------------------------------------------

* Interpretation der Logits mit dem logit oder logistic und anschließend logitistic, coef Befehl
* Vorzeichen Interpretation
* Frauen(female): Frauen befürworten seltener die Legalisierung von Marihuana als Männer (signifikant)
* Bildung (educ): Personen mit höherer Bildung akzeptieren eher die Legalisierung von Marihuana(signifikant)
* Alter (age): Ältere befürworten seltener die Legalisierung von Marihuana (signifikant)

------------------------------------------------------------------------------
      marih1 | Odds Ratio   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
         sex |
     female  |   .6874533   .0684151    -3.77   0.000     .5656294    .8355154
        educ |   1.090809   .0179842     5.27   0.000     1.056124    1.126633
         age |   .9797165    .002782    -7.22   0.000     .9742789    .9851843
       _cons |   1.612509   .4370579     1.76   0.078      .947961    2.742923
------------------------------------------------------------------------------

  Odds of: 1 vs 0

------------------------------------------------------------------------
             |         b        z    P>|z|       e^b   e^bStdX     SDofX
-------------+----------------------------------------------------------
         sex |
     female  |   -0.3748   -3.766    0.000     0.687     0.830     0.498
        educ |    0.0869    5.272    0.000     1.091     1.301     3.024
         age |   -0.0205   -7.216    0.000     0.980     0.698    17.513
    constant |    0.4778    1.763    0.078         .         .         .
------------------------------------------------------------------------
       b = raw coefficient
       z = z-score for test of b=0
   P>|z| = p-value for z-test
     e^b = exp(b) = factor change in odds for unit increase in X
 e^bStdX = exp(b*SD of X) = change in odds for SD increase in X
   SDofX = standard deviation of X
  Odds of: 0 vs 1

------------------------------------------------------------------------
             |         b        z    P>|z|       e^b   e^bStdX     SDofX
-------------+----------------------------------------------------------
         sex |
     female  |   -0.3748   -3.766    0.000     1.455     1.205     0.498
        educ |    0.0869    5.272    0.000     0.917     0.769     3.024
         age |   -0.0205   -7.216    0.000     1.021     1.432    17.513
    constant |    0.4778    1.763    0.078         .         .         .
------------------------------------------------------------------------


* Interpretation der Odds mit logistic-Befehl oder logit und danach logit, or 
* oder listcoef, help, falls Werte unter 1: listcoef, reverse
* Interpretation mit den Werten der Odds (Vorsicht, kein linearer Zusammenhang!):
* Frauen: Kehrwert berechnet, da Wert unter 0 (listcoef, reverse): Für Frauen sind die Odds nicht für eine Legalisierung von Marihuana zu sein
* um das 1.455-fache höher als für Männer
* Bildung: Steigt die Bildung um ein Jahr, erhöhen sich die Odds für Legalisierung von Marihuana um den Faktor 1,09 
* Alter: Kehrwert (listcoef, reverse): Sinkt das Alter um ein Jahr, erhöhen sich die Odds um das 2.1-fache (für die Legalisierung von Marihuana)

* Interpretation als Prozentwerte (Vorsicht, nicht linearer Zusammenhang!)
* Frauen (listcoef, reverse): (1.455-1)*100 = 45.5 %. Die Odds von Frauen für die Nicht-Legalisierung von Marihuana
* sind 45.5 % höher als für Männer
* Bildung: (1.090809-1)*100 = 9.1 %. Steigt die Bildung um ein Jahr, erhöhen sich die Odds für Legalisierung von Marihuana um 9.1 %
* Alter (listcoef, reverse/listcoef, reverse percent): (1.021-1)*100 = 2.1 %. Sinkt das Alter um ein Jahr,
* steigen die Odds um 2.1 % für die Legalisierung von Marihuana*/


* Aufgabe 1b

* Die alleinige Interpretation dieser Kennwerte ist nicht sinnvoll, weitere Tests, wie fitstat sollten durchgeführt werden
* Prob > chi2 =0.0000: Das Gesamtmodell ist signifikant
* Pseudo R2 = 0.0398: McFaddens R2 ist relativ klein

* Aufgabe 1c

display exp(_b[_cons] + _b[1.sex] +_b[educ]*10+ _b[age]*20)
*Die Odds betragen 2.5526857

* Aufgabe 2
* sex hat die Ausprägungen 1 und 2 (weiblich)

margins, at(2.sex=1 educ=13 age=25) noatlegend
*Die Wahrscheinlichkeit beträgt rund 67 %

*Alternativ: mit prtab, nicht bei Faktorvariablen möglich (statt educ kann jede beliebige unabhängige Variable stehen)

logit marih1 dsex educ age
prtab educ if dsex==1 & educ==13 & age==25

* Aufgabe 3a

logit marih1 i.sex educ age
margins, at(educ=(10(2)16) age=(18(10)80)) by(sex) noatlegend
marginsplot, by(sex) 

* Aufgabe 3b

margins, at(age=(18(10)80) educ=(10(2)16)) by(sex) noatlegend
marginsplot, by(sex)

* Aufgabe 4

margins, dydx(*)

/*
------------------------------------------------------------------------------
             |            Delta-method
             |      dy/dx   Std. Err.      z    P>|z|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
         sex |
     female  |  -.0844271   .0222107    -3.80   0.000    -.1279592   -.0408949
        educ |   .0195669   .0036055     5.43   0.000     .0125002    .0266336
         age |  -.0046131   .0006045    -7.63   0.000    -.0057979   -.0034283
------------------------------------------------------------------------------*/

* Interpretation bezieht sich auf Befragte, die bei allen Variablen dem Durchschnitt entsprechen
* Geschlecht: Die Wahrscheinlichkeit eines durchschnittlichen Befragten des weiblichen Geschlechts
* für die Legalisierung von Marihuana P(Y=1) zu stimmen ist 0.0844271 bzw. 8,4 % geringer als für Männer
* Bildung und Alter: Die Wahrscheinlichkeit eines durchschnittlichen Befragten, die Legalisierung von Marihuana
* zu befürworten, erhöhen sich im Mittel (aller Beobachtungen der Stichprobe) um 0.0195669 bzw. 1,96 %, wenn sich die Bildung um eine Einheit (marginal) erhöht 
* wenn das Alter um eine Einheit steigt, sinkt sie um 0.0046131 (0.4 %)

* Aufgabe 5

estat gof, group(10)
* Interpretation: Prob > chi2 = 0.4664. Es ist keine signifikante Diskrepanz zwischen den 
* beobachteten und geschätzten Häufigkeiten vorhanden. Die Wahrscheinlichkeit von über 46 % ist als gut zu bezeichnen.


estat gof
* Die Anzahl der Kovariatenmuster liegt mit 896 im Rahmen.
* Prob > chi2 = 0.2433 liegt unter dem Wert des Hosmer–Lemeshow Tests: die Einteilung der Gruppen 
* beeinflusst den Wert. Dennoch ist der Wert als gut zu bezeichnen.


* Aufgabe 6

codebook deathpen  

* Variable deathpen   0/1 codieren

recode deathpen(1=0)(2=1),gen(deathp)
logit deathp i.sex i.presi

estat classification

/*Classified |         D            ~D  |      Total
-----------+--------------------------+-----------
     +     |       335           273  |        608
     -     |       337           695  |       1032
-----------+--------------------------+-----------
   Total   |       672           968  |       1640

Classified + if predicted Pr(D) >= .5
True D defined as deathp != 0
--------------------------------------------------
Sensitivity                     Pr( +| D)   49.85%
Specificity                     Pr( -|~D)   71.80%
Positive predictive value       Pr( D| +)   55.10%
Negative predictive value       Pr(~D| -)   67.34%
--------------------------------------------------
False + rate for true ~D        Pr( +|~D)   28.20%
False - rate for true D         Pr( -| D)   50.15%
False + rate for classified +   Pr(~D| +)   44.90%
False - rate for classified -   Pr( D| -)   32.66%
--------------------------------------------------
Correctly classified                        62.80%
--------------------------------------------------*/

* Interpretation: 62.80 % werden korrekt klassifiziert. Der Wert entspricht R2 count
* Aber dieser Wert ist mit Vorsicht zu betrachten, da bereits anhand der häufigsten Kategorie eine erste Schätzung erfolgen kann:
* Die häufigtste Kategorie stellen die Befürworter der Todesstrafe dar. 968 von 1680 werden richtig als Befürworter vorhergesagt
* display 968/1640 = 0.5902439 (59 %). Der Wert von 62.80 % ist somit nicht als gut zu bezeichnen, der Zugewinn an Erklärungskraft
* beträgt nicht einmal 4 %. Deshalb sollte statt R2 count der korrigierte Wert (siehe fitstat) berechnet werden
* Sensitivity: 49.85 % der Gegner der Todesstrafe werden richtig klassifiziert
* Specificity: 71.80 % der Befürworter der Todesstrafe werden richtig klassifiziert

* Aufgabe 7

*Fallzahlangleichung berechnen um mit identischer Stichprobe zu arbeiten

egen miss=rowmiss(deathp educ sex presi)
ta miss

quietly logit deathp i.sex i.presi if miss==0
quietly fitstat, save
quietly logit deathp i.sex i.presi educ if miss==0
fitstat, diff

/*
                         |     Current        Saved   Difference 
-------------------------+---------------------------------------
Log-likelihood           |                                       
                   Model |    -995.003    -1013.561       18.558 
          Intercept-only |   -1108.116    -1108.116        0.000 
-------------------------+---------------------------------------
Chi-square               |                                       
      D(df=1632/1633/-1) |    1990.007     2027.122      -37.115 
            LR(df=5/4/1) |     226.226      189.110       37.115 
                 p-value |       0.000        0.000        0.000 
-------------------------+---------------------------------------
R2                       |                                       
                McFadden |       0.102        0.085        0.017 
      McFadden(adjusted) |       0.097        0.081        0.016 
      McKelvey & Zavoina |       0.173        0.145        0.028 
            Cox-Snell/ML |       0.129        0.109        0.020 
  Cragg-Uhler/Nagelkerke |       0.174        0.147        0.027 
                   Efron |       0.131        0.108        0.023 
                Tjur's D |       0.130        0.109        0.022 
                   Count |       0.671        0.628        0.043 
         Count(adjusted) |       0.196        0.090        0.106 
-------------------------+---------------------------------------
IC                       |                                       
                     AIC |    2002.007     2037.122      -35.115 
        AIC divided by N |       1.222        1.244       -0.021 
           BIC(df=6/5/1) |    2034.414     2064.128      -29.714 
-------------------------+---------------------------------------
Variance of              |                                       
                       e |       3.290        3.290        0.000 
                  y-star |       3.979        3.848        0.131 

Note: Likelihood-ratio test assumes saved model nested in current model.

Difference of   29.714 in BIC provides very strong support for current model.*/

* Interpretation: 
* Log-likelihood: Der Unterschied zwischen dem Nullmodell und dem maximierten Modell ist im ersten Regressionsmodell nicht sehr hoch
* im zweiten etwas besser (Differenz  beider Modelle: 18.558): die Schätzung ist somit nicht besonders gut
* Chi-square: Likelihood-Ratio Test zeigt, dass beide Gesamt-Modelle signifikant sind. Das Einbeziehen der Schulbildung (2. Modell) 
* führt zu einer signifikanten Verbesserung. Beide Variablen üben somit gemeinsam in diesem Modell einen signifikanten Einfluss aus
* R2: Die Werte der Pseudo R2 variieren stark (unterschiedliche Berechnungen): Wenn wir Counr R außer acht lassen, können wir die Werte wie folgt interpretieren:
* Im ersten Modell ist der Modellfit eher klein, im Zweiten besser und etwas höher (auch bei den korrigierten Kennwerten)
* IC: Informations-Kriterium AIC und BIC. Die Differenz von AIC besagt, dass das letzte Modell einen besseren Modellfit aufweist (siehe Kommentar)
* Der Wert der Differenz der BIC Werte (29.714) wird als sehr gute Anpassung gegenüber dem zweiten Modell angesehen 
