version 13 //Versionsnummer
use allbus2016_red, clear //Datensatz einlesen

//Beispiele zur foreach-Schleife


//Listentyp Variablenliste
//Erstellt eine Haeufigkeitstabelle fr alle angegebenen Variablen
foreach X of varlist ma01a ma02-ma04 { 
	tabulate `X' 
}

//falls help nicht mehr verfgbar
egen help02=rowmiss(ma01a ma02-ma04)
ta help

foreach V of varlist ma01a ma02-ma04 { //Erstellt eine Haeufigkeitstabelle aller angegebenen Variablen, ohne fehlende Werte bei allen Variablen
	ta `V' if help ==0
}

//Weitere Listentypen

//Listentyp neue Variable
foreach var of newlist v1-v5{
	generate `var'=0
}
//Listentyp Nummernliste
foreach num of numlist 1/4 {
	replace v`num'=1
}

//Listentyp Arbitaere Listen
foreach X in fr01 fr05a fr05b fr07 fr08 fr11 {
	recode `X'(1=4)(2=3)(3=2)(4=1), gen(n`X')
}

//Mehrere Befehle 
foreach var of varlist nfr01 nfr05a nfr05b nfr07 nfr08 nfr11 {
	label variable `var' "`var' umcodierte Variable"
	label define `var'label 1" STIMME VOLL ZU" 2" STIMME EHER ZU" 3"STIMME EHER NICHT ZU" 4"STIMME GAR NICHT ZU"
	label values `var' `var'label
	ta `var' 
}

//Listentyp Nummernliste zur Erstellung neuer Variablen
foreach num of numlist 1/5 {
	generate nvar`num'=0
}

//Umcodieren mit Variablenliste
foreach X of varlist fr01 fr05a fr05b fr07 fr08 fr11 {
	recode `X'(1=4)(2=3)(3=2)(4=1), gen(new`X')
}

exit
