***Uebungsaufgaben 


version 13 //Versionsnummer
use ESS8DE.dta, clear //Datensatz einlesen
set more off

* Aufgabe 1a

pwcorr rlgdgr pray, sig

* Pearsons r betraegt -0,7131; Der Zusammenhang ist sehr stark und negativ: Je religioeser eine Person ist, desto mehr betet sie. Der Zusammenhang ist hochsignifikant

* Aufgabe 1b: Pearsons r ist nur fuer normalverteilte, metrische Variablen und lineare Zusammenhaenge geeignet -> 
* testen ob Variablen normalverteilt sind

* Kern-Dichte-Schaetzer

kdensity rlgdgr, normal
kdensity pray, normal

* oder Shapiro-Francia Test auf Normalverteilung

sfrancia rlgdgr pray

* Variablen sind nicht normalverteilt -> Berechnung von Spearman (oder Kendalls Tau)

spearman rlgdgr pray
ktau rlgdgr pray

* Aufgabe 2a

regress stflife happy
sum stflife

/*
      Source |       SS           df       MS      Number of obs   =     2,843
-------------+----------------------------------   F(1, 2841)      =   2962.18
       Model |  5834.71648         1  5834.71648   Prob > F        =    0.0000
    Residual |  5596.02851     2,841    1.969739   R-squared       =    0.5104
-------------+----------------------------------   Adj R-squared   =    0.5103
       Total |   11430.745     2,842  4.02207776   Root MSE        =    1.4035

------------------------------------------------------------------------------
     stflife |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
       happy |   .8266433   .0151884    54.43   0.000     .7968619    .8564248
       _cons |   1.114037   .1207255     9.23   0.000     .8773187    1.350756
------------------------------------------------------------------------------*/

* Der Zusammenhang ist symmetrisch, es kann nicht unterschieden werden, was die abhaengige Variable und was die unabhaengige ist; Regression nicht unbedingt sinnvolles Analyseverfahren
* Der Determinationskoeffizient zeigt einen starken Zusamenhang an, ueber 51 % der Varianz wird erklaert. Die Stichprobe ist mit 2843 Personen gross, wir haben nur eine unabhaengige Variable -> R2 kann statt Adj R-squared verwendet werden
* Der Standardfehler der Schaetzung lautet: Root MSE = 1.4035; Vergleich mit arithmetischem Mittel von stflife: 7.52319 
display 7.52319*0.3*/
2.256957
* Wert liegt unter der 30 % Schwelle, somit ist der Fehler im Rahmen
* Die Konstante betraegt 1.114037: das ist der Wert, wenn happy=0. Wenn die Befragten sehr unzufrieden sind, betraegt die geschaetzte Lebenzufriedenheit 1.114037
* Das Regressionsgewicht hat den Wert 0.8266433; der Zusammenhang ist positiv: Personen die gluecklicher sind, sind auch zufriedener
* Mit jedem Punktwert auf der Gluecksskala steigt die Lebenszufriedenheit um 0.83 Skalenpunkte an
* Konstante und Regressionsgewicht sind hoch signifikant
* Das 95 % Konfidenzintervall der Regressionskoeffizienten lautet: [0.7968619; 0.8564248] und [0.8773187; 1.350756]

* Aufgabe 2b

regress stflife happy
margins, at (happy=10)

* oder 
predict yhat
ta yhat if happy==10

* oder

display _b[_cons] + _b[happy]*10
*9.3804706

* Aufgabe 2c
* Die Variable ist nominal und muss 0/1 codiert werden 
* Moeglichkeit 1

gen div=1 if dvrcdeva==2
replace div=0 if dvrcdeva==1
regress stflife happy div

* Moeglichkeit 2: tabulate-Befehl in Kombination mit generate verwenden

ta dvrcdeva, gen(div)
regress stflife happy div1


* Moeglichkeit 3: Faktorvariablennotation verwenden

regress stflife happy i.dvrcdeva

* Nicht geschiedene Personen sind um 0.3587742 zufriedener mit dem Leben als geschiedene Personen (hoch signifikant) 
* Variante 2: geschiedene Personen sind um 0.3587742 weniger zufriedener mit dem Leben als nicht geschiedene Personen

* Aufgabe 2d

* Es ist nun zu ueberpruefen, ob das Gesamtmodell signifikant ist: Prob > F = 0.0000; der Test ist hoch signifikant

* Aufgabe 2e

codebook edubde1

* Moeglichkeit 1: Recode und Faktorvariablennotation verwenden

regress stflife happy i.dvrcdeva
recode edubde1(0 2/3=1)(4=2)(5=3)(6=4)(1=.a), gen(d_edu)
ta d_edu
regress stflife happy i.dvrcdeva i.d_edu

* Moeglichkeit 2: Einzelne Dummyvariablen erstellen

gen edu1=1 if edubde1==4
replace edu1=0 if edubde1 !=4 & edubde1 !=1 &  !missing(edubde1)
gen edu2=1 if edubde1==5
replace edu2=0 if edubde1 !=5 & edubde1 !=1 &  !missing(edubde1)
gen edu3=1 if edubde1==6
replace edu3=0 if edubde1 !=6 & edubde1 !=1 &  !missing(edubde1)

tab1 edubde1 edu1-edu3
regress stflife happy div edu1 edu2 edu3 

/*
------------------------------------------------------------------------------
     stflife |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
             |
         edu |
          2  |  -.0237564   .0711205    -0.33   0.738    -.1632116    .1156989
          3  |   .0806176   .1025859     0.79   0.432    -.1205359    .2817711
          4  |   .1820438   .0737749     2.47   0.014     .0373838    .3267038
             |
       _cons |   .8685907    .138194     6.29   0.000     .5976159    1.139566
------------------------------------------------------------------------------*/
		 
* Befragte mit mittlerem Abschluss sind um 0.0237564 Punktwerte unzufriedener als Personen mit dem niedrigstem Bildungsniveau bzw. der Referenzkategorie
* Befragte mit Fachschulabschluss sind um 0.0806176 Punktwerte zufriedener als die Referenzkategorie
* diese Ergebnisse sind nicht signifikant
* Befragte mit Hochschulreife sind um 0.1820438 Punktwerte zufriedener als die Referenzkategorie, das Ergebnis ist signifikant (5 %)

* Aufgabe 3
* Zuerst Angleichung der Fallzahl, um Modelle vergleichen zu koennen

egen missing=rowmiss(stflife happy dvrcdeva d_edu)
regress stflife happy i.dvrcdeva if missing==0
outreg2 using regtab.doc, ctitle(Model 1) replace
regress stflife happy i.(dvrcdeva d_edu) if missing==0
outreg2 using regtab.doc, append ctitle(Model 2) 
shellout regtab.doc

* Aufgabe 4a

use allbus2016_red.dta, clear

* Fehlende Werte ausschliessen

codebook inc S01
mvdecode S01,mv(6/7=.a \ 24/30=.b)

*Verschiedene Scatterplots

scatter inc S01|| lfit inc S01
scatter inc S01, jitter(5) || lfit inc S01
binscatter inc S01

* Normales Streudiagramm nicht gut geeignet, Jitter-Plot besser, binscatter ist am anschaulichsten
* Mit line(qfit) Test, ob nicht-linearer Zusammenhang

binscatter inc S01, line(qfit)

* Zusammenhang annaehernd linear, wenngleich einige Ausreisser existieren

* Aufgabe 4b

regress inc S01 i.sex

* Oder eine Dummyvariable konstruieren

gen sex01=1 if sex==2
replace sex01=0 if sex==1
regress inc S01 sex01


* Aufgabe 4c
/*
------------------------------------------------------------------------------
         inc |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
         S01 |   125.3083   17.94281     6.98   0.000     89.99312    160.6234
             |
         sex |
       FRAU  |  -750.0281   119.0065    -6.30   0.000    -984.2574   -515.7988
------------------------------------------------------------------------------*/

* Der Zusammenhang zwischen den Bildungsjahren und dem Einkommen ist positiv und hoch signifikant; Je hoeher die Bildung, desto hoeher ist das Einkommen
* Pro Bildungsjahr steigt das Einkommen um 125.3083 €
* Dummyvariable Geschlecht: Frauen verdienen -750.0281 weniger als Maenner, bei gleicher Bildung 

* Aufgabe 4d

* Bildung Mittelwert zentrieren und das erste Modell nochmals berechnen

sum S01 if !missing(inc, S01, sex)
gen c_S01=S01-r(mean)
regress inc c_S01 i.sex

*Die Zentrierung ist fuer die Interpretation der Konstante notwendig. Besser waere eine Zentrierung um den Wert der minimalen Schulbildung: 8 Jahre
* somit wuerde der Wert null 8 Schuljahre repraesentieren und nicht das arithmetische Mittel der Schuljahre

* Wir vermuten einen Interaktionseffekt zwischen der Bildung und dem Geschlecht

regress inc c.c_S01##i.sex
margins sex, at(c_S01=(0(1)10))
marginsplot, noci

* Modell ohne Interaktionseffekt R-squared = 0.2241

/*
      Source |       SS           df       MS      Number of obs   =       292
-------------+----------------------------------   F(3, 288)       =     32.88
       Model |  97880487.4         3  32626829.1   Prob > F        =    0.0000
    Residual |   285785395       288    992310.4   R-squared       =    0.2551
-------------+----------------------------------   Adj R-squared   =    0.2474
       Total |   383665883       291  1318439.46   Root MSE        =    996.15

------------------------------------------------------------------------------
         inc |      Coef.   Std. Err.      t    P>|t|     [95% Conf. Interval]
-------------+----------------------------------------------------------------
       c_S01 |   182.9599   24.23639     7.55   0.000      135.257    230.6628
             |
         sex |
       FRAU  |  -748.4888   116.8075    -6.41   0.000    -978.3934   -518.5842
             |
 sex#c.c_S01 |
       FRAU  |  -122.1449   35.27766    -3.46   0.001    -191.5796   -52.71011
             |
       _cons |   1956.855   82.30246    23.78   0.000     1794.865    2118.846
------------------------------------------------------------------------------*/

* Conditional-Effect-Plot unter UebungenKapitel06Plot.gph
* R2 ist im neuen Modell hoeher, alle Koeffizienten und das Gesamtmodell sind signifikant
* sex: Frau=1; Mann=0 (Refrenzkategorie)
* Maenner mit durchschnittlicher Bildung verdienen 1956.855 €
display _b[_cons] + _b[c_S01]*0 + _b[1.sex] + _b[1.sex#c.c_S01]*0
* S01: Fuer Maenner, die ein Jahr mehr Bildung aufweisen, ist das Einkommen um 182.9599 € hoeher= Regressionsgewicht Maenner
display  _b[c_S01]*1
* Das geschaetze Einkommen betraegt nun:
display _b[_cons] + _b[c_S01]*1 + _b[1.sex] + _b[1.sex#c.c_S01]*0
* Frauen mit durchschnittlicher Bildung verdienen 748.4888 € weniger als Maenner: 1956.855 - 748.4888 
display  _b[2.sex] 
* Das entspricht:
display _b[_cons] + _b[c_S01]*0 + _b[2.sex] + _b[2.sex#c.c_S01]*0
* 1208.3662
* Fuer Frauen, die ein Jahr mehr Bildung aufweisen, liegt das Einkommen bei 182.9599 - 122.1449 € = Regressionsgewicht Frauen
display _b[c_S01]*1 + _b[2.sex#c.c_S01]
* Der Schaetzwert betraegt somit 1208,3662 + 60,815
display _b[_cons] + _b[c_S01]*1 + _b[2.sex] + _b[2.sex#c.c_S01]
* Der negative Wert des Intreaktionsterms und positive Wert der Altersvariable gibt an, dass die Kluft zwischen Maennern und Frauen bei hoeherer Bildung hoeher ausfaellt
* Schaetzwert Einkommen bei 13 Jahren Schulbildung:
* Frauen:
display _b[_cons] + _b[c_S01]*5 + _b[2.sex] + _b[2.sex#c.c_S01]*5
* 1517.6362
* Maenner:
display _b[_cons] + _b[c_S01]*5 + _b[1.sex] + _b[1.sex#c.c_S01]*5
* 2623.9415

* Aufgabe 5a

use umwelt.dta, clear

regress umweltein inno konsum i.bild

* Aufgabe 5b

ta bild
regress umweltein inno konsum ib(3).bild

* Aufgabe 5c

* 1)Linearitaet ueberpruefen fuer inno und konsum

regress umweltein inno konsum ib(3).bild
acprplot inno, lowess
* nur geringe Abweichungen, deshalb ok
acprplot konsum, lowess
* nur geringe Abweichungen, deshalb ok

* 2)Sind die Residuen normalverteilt?

predict res, residuals
sfrancia res
qnorm res

/*               Shapiro-Francia W' test for normal data

    Variable |       Obs       W'          V'        z       Prob>z
-------------+-----------------------------------------------------
         res |     1,147    0.99572      3.242     2.720    0.00326*/

* p-Wert ist kleiner als 0,05 -> Residuen sind nicht normalverteilt
* Normal-Probability Plot zeigt leichte Abweichung von der Normalverteilung

* Ueberpruefen: Ist die abhaengige Variable sehr schief?

kdensity umweltein, normal

histogram res, normal
* Etwas schief, evtl. auf Ausreisser ueberpruefen, zudem: Stichprobe gross deshalb kann Modell so berechnet werden

* 3)Besteht Multikollinearitaet?

estat vif
* Nein, Werte nahe bei 1

* 4) Streuen Residuen gleichmaessig?

rvfplot, yline(0)
* Etwas ungleichmaessiges Bild

estat imtest, white

/*White's test for Ho: homoskedasticity
         against Ha: unrestricted heteroskedasticity

         chi2(11)     =     44.54
         Prob > chi2  =    0.0000

Cameron & Trivedi's decomposition of IM-test

---------------------------------------------------
              Source |       chi2     df      p
---------------------+-----------------------------
  Heteroskedasticity |      44.54     11    0.0000
            Skewness |      11.09      4    0.0256
            Kurtosis |       0.34      1    0.5596
---------------------+-----------------------------
               Total |      55.97     16    0.0000
---------------------------------------------------*/


* p-Wert ist kleiner als 0,05 -> Residuen sind nicht gleich verteilt (homoskedastisch)
* Evtl. Transformation der AV, Spezifikationsfehler? Neuspezifikation des Regressionsmodell, Recodierung von X-Variablen, Regression mit robustem Standardfehler

* Aufgabe 6
use Dateien ESS8DE.dta, clear
codebook inc agea
regress inc agea if agea<66
binscatter inc agea if agea<66
binscatter inc agea if agea<66, line(qfit)

 *Zusammenhang ist eher quadratisch: Quadratischen Term fuer Alter zusaetzlich mit ins Modell aufnehmen

regress inc c.age##c.age if age<66
* Modell passt etwas besser: R2 groesser etc.
margins, at(age=(18(1)65))
marginsplot

* Oder Hyperbolisch

regress inc c.age#c.age if age<66
* Modell passt etwas besser: R2 groesser etc.
margins, at(age=(18(1)65))
marginsplot

* Evtl. Alter in Gruppen einteilen und Modell mit Dummyvariablen rechnen

* Aufgabe 7

use allbus216_red.dta, clear
* Fehlende Werte ausschliessen

codebook inc S01
mvdecode S01,mv(6/7=.a \ 24/30=.b)

regress ls01 S01
binscatter ls01 S01
binscatter ls01 S01, line(qfit)
* Zusammenhnag ist leicht logarithmisch

gen eduy=log(S01)
regress ls01 eduy
binscatter ls01 eduy, line(qfit)
* Modell passt etwas besser, aber nicht sehr gut
* Besser Bildung in Gruppen darstellen, als Dummyvariablen, zum Beispiel:
regress ls01 io(6/7).educ

